/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.api.opennms;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.api.SnmpDaemon;
import net.sf.snmpadaptor4j.api.SnmpDaemonConfiguration;
import net.sf.snmpadaptor4j.api.SnmpException;
import net.sf.snmpadaptor4j.api.SnmpMib;
import net.sf.snmpadaptor4j.api.opennms.OpennmsSupport;
import net.sf.snmpadaptor4j.object.SnmpOid;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.opennms.protocols.snmp.SnmpAgentHandler;
import org.opennms.protocols.snmp.SnmpAgentSession;
import org.opennms.protocols.snmp.SnmpEndOfMibView;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduBulk;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class OpennmsSnmpDaemon
extends OpennmsSupport
implements SnmpDaemon,
SnmpAgentHandler {
    private final SnmpDaemonConfiguration configuration;
    protected final SnmpMib snmpMib;
    private SnmpAgentSession snmpSession = null;

    OpennmsSnmpDaemon(SnmpDaemonConfiguration configuration, SnmpMib snmpMib) {
        this.configuration = configuration;
        this.snmpMib = snmpMib;
    }

    @Override
    public final synchronized void start() throws Exception {
        if (this.snmpSession == null) {
            this.logger.trace((Object)"SNMP daemon starting...");
            this.logger.debug((Object)("SNMP daemon will listen on " + this.configuration.getListenerAddress() + ":" + this.configuration.getListenerPort()));
            SnmpPeer peer = new SnmpPeer(InetAddress.getByName(this.configuration.getListenerAddress()), this.configuration.getListenerPort().intValue());
            SnmpParameters params = peer.getParameters();
            switch (this.configuration.getListenerSnmpVersion()) {
                case 1: {
                    params.setVersion(0);
                    break;
                }
                default: {
                    params.setVersion(1);
                }
            }
            params.setReadCommunity(this.configuration.getListenerReadCommunity());
            params.setWriteCommunity(this.configuration.getListenerWriteCommunity());
            this.snmpSession = new SnmpAgentSession((SnmpAgentHandler)this, peer);
            this.logger.info((Object)("SNMP daemon listen on " + this.configuration.getListenerAddress() + ":" + this.configuration.getListenerPort()));
            this.logger.trace((Object)"SNMP daemon started");
        } else {
            this.logger.trace((Object)"SNMP daemon already started");
        }
    }

    @Override
    public final synchronized void stop() {
        if (this.snmpSession != null) {
            this.logger.trace((Object)"SNMP daemon stopping...");
            this.snmpSession.close();
            this.snmpSession = null;
            this.logger.trace((Object)"SNMP daemon stopped");
        } else {
            this.logger.trace((Object)"SNMP daemon already stopped");
        }
    }

    @Override
    public final boolean isStarted() {
        return this.snmpSession != null;
    }

    public final void SnmpAgentSessionError(SnmpAgentSession session, int error, Object ref) {
        throw new SnmpException(error);
    }

    public final void snmpReceivedPdu(SnmpAgentSession session, InetAddress manager, int port, SnmpOctetString community, SnmpPduPacket pdu) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(pdu.getRequestId() + ": in treating by snmpReceivedPdu..."));
        }
        if (pdu instanceof SnmpPduBulk) {
            SnmpPduRequest response = new SnmpPduRequest(162);
            response.setRequestId(pdu.getRequestId());
            this.doBulk(pdu.toVarBindArray(), (SnmpPduBulk)pdu, response);
            try {
                this.sendPduPacket(session, new SnmpPeer(manager, port), (SnmpPduPacket)response);
            }
            catch (AsnEncodingException e) {
                this.logger.error((Object)(pdu.getRequestId() + ": error " + 1 + " (response too big)"));
                SnmpPduRequest errorResponse = new SnmpPduRequest(162);
                errorResponse.setRequestId(pdu.getRequestId());
                errorResponse.setErrorStatus(1);
                errorResponse.setErrorIndex(0);
                try {
                    this.sendPduPacket(session, new SnmpPeer(manager, port), (SnmpPduPacket)errorResponse);
                }
                catch (Throwable e1) {
                    this.logger.error((Object)(pdu.getRequestId() + ": an error has occurred when the error response sending"), e1);
                }
            }
            catch (Throwable e) {
                this.logger.error((Object)(pdu.getRequestId() + ": error " + 5 + " (general error)"), e);
                SnmpPduRequest errorResponse = new SnmpPduRequest(162);
                errorResponse.setRequestId(pdu.getRequestId());
                errorResponse.setErrorStatus(5);
                errorResponse.setErrorIndex(0);
                try {
                    this.sendPduPacket(session, new SnmpPeer(manager, port), (SnmpPduPacket)errorResponse);
                }
                catch (Throwable e1) {
                    this.logger.error((Object)(pdu.getRequestId() + ": an error has occurred when the error response sending"), e1);
                }
            }
        } else {
            this.logger.error((Object)(pdu.getRequestId() + ": request ignored (PDU " + pdu.getClass().getSimpleName() + " unhandled)"));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(pdu.getRequestId() + ": treated by snmpReceivedPdu"));
        }
    }

    protected void sendPduPacket(SnmpAgentSession session, SnmpPeer peer, SnmpPduPacket pdu) throws Exception {
        session.send(peer, pdu);
    }

    public final SnmpPduRequest snmpReceivedGet(SnmpPduPacket pdu, boolean getNext) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(pdu.getRequestId() + ": in treating by snmpReceivedGet..."));
        }
        SnmpPduRequest response = new SnmpPduRequest(162);
        response.setRequestId(pdu.getRequestId());
        SnmpVarBind[] binds = pdu.toVarBindArray();
        if (binds.length > 20) {
            this.logger.error((Object)(pdu.getRequestId() + ": error " + 1 + " (too OIDs - limited to 20)"));
            response.setErrorStatus(1);
            response.setErrorIndex(0);
        } else if (pdu instanceof SnmpPduRequest) {
            int resultIndex = 1;
            try {
                for (SnmpVarBind varBind : binds) {
                    AttributeAccessor attributeAccessor;
                    SnmpOid oid = SnmpOid.newInstance(varBind.getName().getIdentifiers());
                    if (getNext) {
                        attributeAccessor = this.snmpMib.next(oid);
                        if (attributeAccessor == null) {
                            response.addVarBind(new SnmpVarBind(varBind.getName()));
                            throw new SnmpException("none OID found after " + oid, 2, Level.DEBUG);
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)(pdu.getRequestId() + ": " + oid + " --next--> " + attributeAccessor));
                        }
                        response.addVarBind(this.newSnmpVarBind(attributeAccessor));
                    } else {
                        attributeAccessor = this.snmpMib.find(oid);
                        if (attributeAccessor == null) {
                            response.addVarBind(new SnmpVarBind(varBind.getName()));
                            throw new SnmpException("OID " + oid + " not found", 2, Level.DEBUG);
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)(pdu.getRequestId() + ": " + attributeAccessor));
                        }
                        varBind.setValue(OpennmsSnmpDaemon.newSnmpValue(attributeAccessor));
                        response.addVarBind(varBind);
                    }
                    ++resultIndex;
                }
            }
            catch (SnmpException e) {
                this.logger.log((Priority)e.getLoggerLevel(), (Object)(pdu.getRequestId() + ": " + e.getMessage()), e.getCause());
                response.setErrorStatus(e.getErrorStatus());
                response.setErrorIndex(resultIndex);
            }
            catch (Throwable e) {
                this.logger.error((Object)(pdu.getRequestId() + ": error " + 5 + " (general error)"), e);
                response.setErrorStatus(5);
                response.setErrorIndex(resultIndex);
            }
        } else if (pdu instanceof SnmpPduBulk) {
            this.doBulk(binds, (SnmpPduBulk)pdu, response);
        } else {
            this.logger.error((Object)(pdu.getRequestId() + ": error " + 5 + " (PDU " + pdu.getClass().getSimpleName() + " unhandled)"));
            response.setErrorStatus(5);
            response.setErrorIndex(0);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(pdu.getRequestId() + ": treated by snmpReceivedGet"));
        }
        return response;
    }

    private void doBulk(SnmpVarBind[] binds, SnmpPduBulk bulk, SnmpPduRequest response) {
        int resultIndex = 1;
        try {
            for (SnmpVarBind varBind : binds) {
                AttributeAccessor attributeAccessor;
                SnmpOid oid = SnmpOid.newInstance(varBind.getName().getIdentifiers());
                if (resultIndex <= bulk.getNonRepeaters()) {
                    attributeAccessor = this.snmpMib.next(oid);
                    if (attributeAccessor != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)(bulk.getRequestId() + ": " + oid + " --next--> " + attributeAccessor));
                        }
                        response.addVarBind(this.newSnmpVarBind(attributeAccessor));
                    } else {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)(bulk.getRequestId() + ": " + oid + " --next--> END OF MIB"));
                        }
                        response.addVarBind(new SnmpVarBind(varBind.getName(), (SnmpSyntax)new SnmpEndOfMibView()));
                    }
                } else {
                    Iterator<Map.Entry<SnmpOid, AttributeAccessor>> attributeAccessorEntryIterator = this.snmpMib.nextSet(oid).entrySet().iterator();
                    if (attributeAccessorEntryIterator.hasNext()) {
                        int i;
                        for (i = 0; attributeAccessorEntryIterator.hasNext() && i < bulk.getMaxRepititions(); ++i) {
                            attributeAccessor = attributeAccessorEntryIterator.next().getValue();
                            if (this.logger.isDebugEnabled()) {
                                if (i == 0) {
                                    this.logger.debug((Object)(bulk.getRequestId() + ": " + oid + " --next--> " + attributeAccessor));
                                } else {
                                    this.logger.debug((Object)(bulk.getRequestId() + ": " + String.format("%" + oid.toString().length() + "s", "") + " --next--> " + attributeAccessor));
                                }
                            }
                            response.addVarBind(this.newSnmpVarBind(attributeAccessor));
                        }
                        if (i < bulk.getMaxRepititions()) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)(bulk.getRequestId() + ": " + oid + " --next--> .1.9: END OF MIB"));
                            }
                            response.addVarBind(new SnmpVarBind(".1.9", (SnmpSyntax)new SnmpEndOfMibView()));
                        }
                    } else {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)(bulk.getRequestId() + ": " + oid + " --next--> END OF MIB"));
                        }
                        response.addVarBind(new SnmpVarBind(varBind.getName(), (SnmpSyntax)new SnmpEndOfMibView()));
                    }
                }
                ++resultIndex;
            }
        }
        catch (SnmpException e) {
            this.logger.log((Priority)e.getLoggerLevel(), (Object)(bulk.getRequestId() + ": " + e.getMessage()), e.getCause());
            response.setErrorStatus(e.getErrorStatus());
            response.setErrorIndex(resultIndex);
        }
        catch (Throwable e) {
            this.logger.error((Object)(bulk.getRequestId() + ": error " + 5 + " (general error)"), e);
            response.setErrorStatus(5);
            response.setErrorIndex(resultIndex);
        }
    }

    public SnmpPduRequest snmpReceivedSet(SnmpPduPacket pdu) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(pdu.getRequestId() + ": in treating by snmpReceivedSet..."));
        }
        SnmpPduRequest response = new SnmpPduRequest(162);
        response.setRequestId(pdu.getRequestId());
        SnmpVarBind[] binds = pdu.toVarBindArray();
        if (binds.length > 20) {
            this.logger.error((Object)(pdu.getRequestId() + ": error " + 1 + " (too OIDs - limited to 20)"));
            response.setErrorStatus(1);
            response.setErrorIndex(0);
        } else {
            int resultIndex = 1;
            try {
                for (SnmpVarBind varBind : binds) {
                    SnmpOid oid = SnmpOid.newInstance(varBind.getName().getIdentifiers());
                    SnmpSyntax newValue = varBind.getValue();
                    AttributeAccessor attributeAccessor = this.snmpMib.find(oid);
                    if (attributeAccessor == null) {
                        response.addVarBind(new SnmpVarBind(varBind.getName()));
                        throw new SnmpException("OID " + oid + " not found", 2, Level.DEBUG);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)(pdu.getRequestId() + ": old " + attributeAccessor));
                    }
                    OpennmsSnmpDaemon.setValue(attributeAccessor, newValue);
                    response.addVarBind(this.newSnmpVarBind(attributeAccessor));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)(pdu.getRequestId() + ": new " + attributeAccessor));
                    }
                    ++resultIndex;
                }
            }
            catch (SnmpException e) {
                this.logger.log((Priority)e.getLoggerLevel(), (Object)(pdu.getRequestId() + ": " + e.getMessage()), e.getCause());
                response.setErrorStatus(e.getErrorStatus());
                response.setErrorIndex(resultIndex);
            }
            catch (Throwable e) {
                this.logger.error((Object)(pdu.getRequestId() + ": error " + 5 + " (general error)"), e);
                response.setErrorStatus(5);
                response.setErrorIndex(resultIndex);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(pdu.getRequestId() + ": treated by snmpReceivedSet"));
        }
        return response;
    }

    private SnmpVarBind newSnmpVarBind(AttributeAccessor attributeAccessor) throws Exception {
        return new SnmpVarBind(new SnmpObjectId(attributeAccessor.getOid().getOid()), OpennmsSnmpDaemon.newSnmpValue(attributeAccessor));
    }

    protected static SnmpSyntax newSnmpValue(AttributeAccessor attributeAccessor) throws Exception {
        Object value;
        if (!attributeAccessor.isReadable()) {
            throw new SnmpException("MBean attribute is not readable", 6);
        }
        try {
            value = attributeAccessor.getValue();
        }
        catch (Throwable e) {
            throw new SnmpException("Impossible to read the attribute due to error", 6, e);
        }
        return OpennmsSnmpDaemon.newSnmpValue(attributeAccessor.getSnmpDataType(), value);
    }

    protected static void setValue(AttributeAccessor attributeAccessor, SnmpSyntax newValue) throws Exception {
        if (!attributeAccessor.isReadable()) {
            throw new SnmpException("MBean attribute is not readable", 6);
        }
        if (!attributeAccessor.isWritable()) {
            throw new SnmpException("MBean attribute is not writable", 17);
        }
        Object value = OpennmsSnmpDaemon.newJmxValue(attributeAccessor.getJmxDataType(), attributeAccessor.getSnmpDataType(), newValue);
        try {
            attributeAccessor.setValue(value);
        }
        catch (Throwable e) {
            throw new SnmpException("Impossible to write in the attribute due to error", 17, e);
        }
    }

    public String toString() {
        return "SnmpDaemon:opennms[" + (this.configuration != null ? this.configuration.getListenerAddress() + ":" + this.configuration.getListenerPort() : "null") + "]";
    }
}

