/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.core.trap;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.snmpadaptor4j.SnmpManagerConfiguration;
import net.sf.snmpadaptor4j.api.SnmpApiFactory;
import net.sf.snmpadaptor4j.api.SnmpTrapSender;
import net.sf.snmpadaptor4j.object.SnmpTrap;
import org.apache.log4j.Logger;

public class SnmpManagers {
    private static final long CONNECTION_DURATION = 30000L;
    protected final Logger logger = Logger.getLogger(SnmpManagers.class);
    private final long connectionDuration;
    protected final List<SnmpTrapSender> senderList = new ArrayList<SnmpTrapSender>();
    private final SnmpApiFactory senderFactory;
    protected Timer timer = null;
    protected long closingTime = Long.MAX_VALUE;

    public SnmpManagers(SnmpApiFactory senderFactory) {
        this(senderFactory, 30000L);
    }

    protected SnmpManagers(SnmpApiFactory senderFactory, long connectionDuration) {
        this.senderFactory = senderFactory;
        this.connectionDuration = connectionDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize(List<SnmpManagerConfiguration> managerList) throws Exception {
        List<SnmpTrapSender> list = this.senderList;
        synchronized (list) {
            this.senderList.clear();
            InetAddress agentAddress = InetAddress.getLocalHost();
            this.logger.info((Object)("Local IP address (SNMP agent) = " + agentAddress));
            for (SnmpManagerConfiguration manager : managerList) {
                this.logger.info((Object)("SNMP manager at " + manager.getAddress() + ":" + manager.getPort() + " (v" + manager.getVersion() + " - community " + manager.getCommunity() + ")"));
                this.senderList.add(this.senderFactory.newSnmpTrapSender(agentAddress, manager.getAddress(), manager.getPort(), manager.getVersion(), manager.getCommunity()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SnmpTrap trap) {
        List<SnmpTrapSender> list = this.senderList;
        synchronized (list) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("New " + trap + " to send"));
            }
            if (this.logger.isTraceEnabled()) {
                trap.traceTo(this.logger);
            }
            for (SnmpTrapSender sender : this.senderList) {
                try {
                    if (!sender.isConnected()) {
                        sender.open();
                    }
                    sender.send(trap);
                }
                catch (Throwable e) {
                    this.logger.error((Object)("Unable to send a trap to the SNMP manager at " + sender.getName()), e);
                }
            }
            this.closingTime = System.currentTimeMillis() + this.connectionDuration;
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new ClosingTask(), this.connectionDuration, this.connectionDuration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        this.logger.trace((Object)"Checking Connections to the SNMP managers...");
        if (this.closingTime < System.currentTimeMillis()) {
            List<SnmpTrapSender> list = this.senderList;
            synchronized (list) {
                if (this.closingTime < System.currentTimeMillis()) {
                    this.logger.trace((Object)"Closing connections to the SNMP managers...");
                    this.timer.cancel();
                    this.timer = null;
                    this.closingTime = Long.MAX_VALUE;
                    for (SnmpTrapSender sender : this.senderList) {
                        try {
                            if (!sender.isConnected()) continue;
                            sender.close();
                        }
                        catch (Throwable e) {
                            this.logger.error((Object)("Unable to close the connection to the SNMP manager at " + sender.getName()), e);
                        }
                    }
                    this.logger.debug((Object)"Connections closed to the SNMP managers");
                }
            }
        }
    }

    public final String toString() {
        return "SnmpManagers";
    }

    final class ClosingTask
    extends TimerTask {
        ClosingTask() {
        }

        @Override
        public void run() {
            SnmpManagers.this.close();
        }
    }
}

