/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling.builder;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.callgraph.CallGraph;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.tooling.EmptyTeaVMToolLog;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMTool;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.builder.BuildException;
import org.teavm.tooling.builder.BuildResult;
import org.teavm.tooling.builder.BuildStrategy;
import org.teavm.tooling.builder.ClassLoaderFactory;
import org.teavm.tooling.sources.DirectorySourceFileProvider;
import org.teavm.tooling.sources.JarSourceFileProvider;
import org.teavm.tooling.sources.SourceFileProvider;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMProgressListener;

public class InProcessBuildStrategy
implements BuildStrategy {
    private final ClassLoaderFactory classLoaderFactory;
    private List<String> classPathEntries = new ArrayList<String>();
    private TeaVMTargetType targetType;
    private String mainClass;
    private String entryPointName;
    private String targetDirectory;
    private String targetFileName = "";
    private boolean incremental;
    private String cacheDirectory;
    private TeaVMOptimizationLevel optimizationLevel = TeaVMOptimizationLevel.ADVANCED;
    private boolean fastDependencyAnalysis;
    private boolean obfuscated;
    private boolean strict;
    private int maxTopLevelNames;
    private boolean sourceMapsFileGenerated;
    private boolean debugInformationGenerated;
    private boolean sourceFilesCopied;
    private String[] transformers = new String[0];
    private String[] classesToPreserve = new String[0];
    private WasmBinaryVersion wasmVersion = WasmBinaryVersion.V_0x1;
    private int minHeapSize = 0x4B4000;
    private int maxHeapSize = 0x8000000;
    private final List<SourceFileProvider> sourceFileProviders = new ArrayList<SourceFileProvider>();
    private boolean longjmpSupported = true;
    private boolean heapDump;
    private TeaVMProgressListener progressListener;
    private Properties properties = new Properties();
    private TeaVMToolLog log = new EmptyTeaVMToolLog();
    private boolean shortFileNames;
    private boolean assertionsRemoved;

    public InProcessBuildStrategy(ClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
    }

    @Override
    public void init() {
        this.sourceFileProviders.clear();
    }

    @Override
    public void addSourcesDirectory(String directory) {
        this.sourceFileProviders.add(new DirectorySourceFileProvider(new File(directory)));
    }

    @Override
    public void addSourcesJar(String jarFile) {
        this.sourceFileProviders.add(new JarSourceFileProvider(new File(jarFile)));
    }

    @Override
    public void setClassPathEntries(List<String> entries) {
        this.classPathEntries.clear();
        this.classPathEntries.addAll(entries);
    }

    @Override
    public void setTargetType(TeaVMTargetType targetType) {
        this.targetType = targetType;
    }

    @Override
    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public void setEntryPointName(String entryPointName) {
        this.entryPointName = entryPointName;
    }

    @Override
    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    @Override
    public void setSourceMapsFileGenerated(boolean sourceMapsFileGenerated) {
        this.sourceMapsFileGenerated = sourceMapsFileGenerated;
    }

    @Override
    public void setDebugInformationGenerated(boolean debugInformationGenerated) {
        this.debugInformationGenerated = debugInformationGenerated;
    }

    @Override
    public void setSourceFilesCopied(boolean sourceFilesCopied) {
        this.sourceFilesCopied = sourceFilesCopied;
    }

    @Override
    public void setProgressListener(TeaVMProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    @Override
    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
    }

    @Override
    public void setLog(TeaVMToolLog log) {
        this.log = log;
    }

    @Override
    public void setObfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
    }

    @Override
    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public void setMaxTopLevelNames(int maxTopLevelNames) {
        this.maxTopLevelNames = maxTopLevelNames;
    }

    @Override
    public void setTransformers(String[] transformers) {
        this.transformers = (String[])transformers.clone();
    }

    @Override
    public void setOptimizationLevel(TeaVMOptimizationLevel level) {
        this.optimizationLevel = level;
    }

    @Override
    public void setFastDependencyAnalysis(boolean fastDependencyAnalysis) {
        this.fastDependencyAnalysis = fastDependencyAnalysis;
    }

    @Override
    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    @Override
    public void setClassesToPreserve(String[] classesToPreserve) {
        this.classesToPreserve = (String[])classesToPreserve.clone();
    }

    @Override
    public void setCacheDirectory(String cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public void setWasmVersion(WasmBinaryVersion wasmVersion) {
        this.wasmVersion = wasmVersion;
    }

    @Override
    public void setMinHeapSize(int minHeapSize) {
        this.minHeapSize = minHeapSize;
    }

    @Override
    public void setMaxHeapSize(int maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    @Override
    public void setLongjmpSupported(boolean longjmpSupported) {
        this.longjmpSupported = longjmpSupported;
    }

    @Override
    public void setHeapDump(boolean heapDump) {
        this.heapDump = heapDump;
    }

    @Override
    public void setShortFileNames(boolean shortFileNames) {
        this.shortFileNames = shortFileNames;
    }

    @Override
    public void setAssertionsRemoved(boolean assertionsRemoved) {
        this.assertionsRemoved = assertionsRemoved;
    }

    @Override
    public BuildResult build() throws BuildException {
        TeaVMTool tool = new TeaVMTool();
        tool.setProgressListener(this.progressListener);
        tool.setLog(this.log);
        tool.setTargetType(this.targetType);
        tool.setMainClass(this.mainClass);
        tool.setEntryPointName(this.entryPointName);
        tool.setTargetDirectory(new File(this.targetDirectory));
        tool.setTargetFileName(this.targetFileName);
        tool.setClassLoader(this.buildClassLoader());
        tool.setOptimizationLevel(this.optimizationLevel);
        tool.setFastDependencyAnalysis(this.fastDependencyAnalysis);
        tool.setSourceMapsFileGenerated(this.sourceMapsFileGenerated);
        tool.setDebugInformationGenerated(this.debugInformationGenerated);
        tool.setSourceFilesCopied(this.sourceFilesCopied);
        tool.setObfuscated(this.obfuscated);
        tool.setStrict(this.strict);
        tool.setMaxTopLevelNames(this.maxTopLevelNames);
        tool.setIncremental(this.incremental);
        tool.getTransformers().addAll(Arrays.asList(this.transformers));
        tool.getClassesToPreserve().addAll(Arrays.asList(this.classesToPreserve));
        tool.setCacheDirectory(this.cacheDirectory != null ? new File(this.cacheDirectory) : null);
        tool.setWasmVersion(this.wasmVersion);
        tool.setMinHeapSize(this.minHeapSize);
        tool.setMaxHeapSize(this.maxHeapSize);
        tool.setLongjmpSupported(this.longjmpSupported);
        tool.setHeapDump(this.heapDump);
        tool.setShortFileNames(this.shortFileNames);
        tool.setAssertionsRemoved(this.assertionsRemoved);
        tool.getProperties().putAll((Map<?, ?>)this.properties);
        for (SourceFileProvider fileProvider : this.sourceFileProviders) {
            tool.addSourceFileProvider(fileProvider);
        }
        try {
            tool.generate();
        }
        catch (Error | RuntimeException | TeaVMToolException e) {
            throw new BuildException(e);
        }
        Set<String> generatedFiles = tool.getGeneratedFiles().stream().map(File::getAbsolutePath).collect(Collectors.toSet());
        return new InProcessBuildResult(tool.getDependencyInfo().getCallGraph(), tool.getProblemProvider(), tool.getClasses(), tool.getUsedResources(), generatedFiles);
    }

    private ClassLoader buildClassLoader() {
        URL[] urls = (URL[])this.classPathEntries.stream().map(entry -> {
            try {
                return new File((String)entry).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException((String)entry);
            }
        }).toArray(URL[]::new);
        return this.classLoaderFactory.create(urls, InProcessBuildStrategy.class.getClassLoader());
    }

    static class InProcessBuildResult
    implements BuildResult {
        private CallGraph callGraph;
        private ProblemProvider problemProvider;
        private Collection<String> classes;
        private Collection<String> usedResources;
        private Collection<String> generatedFiles;

        InProcessBuildResult(CallGraph callGraph, ProblemProvider problemProvider, Collection<String> classes, Collection<String> usedResources, Collection<String> generatedFiles) {
            this.callGraph = callGraph;
            this.problemProvider = problemProvider;
            this.classes = classes;
            this.usedResources = usedResources;
            this.generatedFiles = generatedFiles;
        }

        @Override
        public CallGraph getCallGraph() {
            return this.callGraph;
        }

        @Override
        public ProblemProvider getProblems() {
            return this.problemProvider;
        }

        @Override
        public Collection<String> getClasses() {
            return this.classes;
        }

        @Override
        public Collection<String> getUsedResources() {
            return this.usedResources;
        }

        @Override
        public Collection<String> getGeneratedFiles() {
            return this.generatedFiles;
        }
    }
}

